/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common;

import gov.nih.nci.cagrid.common.SchemaValidationException;
import gov.nih.nci.cagrid.common.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaValidator {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String W3C_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private SAXParserFactory factory;
    private SAXParser parser;

    public SchemaValidator(String schemaFilename) throws SchemaValidationException {
        try {
            this.factory = SAXParserFactory.newInstance();
            this.factory.setValidating(true);
            this.factory.setNamespaceAware(true);
            if (!this.factory.isValidating()) {
                throw new SchemaValidationException("Unable to set validation on sax parser factory: " + this.factory.getClass().getName());
            }
            this.parser = this.factory.newSAXParser();
            this.parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_NAMESPACE);
            this.parser.setProperty(JAXP_SCHEMA_SOURCE, schemaFilename);
        }
        catch (ParserConfigurationException ex) {
            throw new SchemaValidationException("Error configuring SAX parser: " + ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            throw new SchemaValidationException("Error in SAX: " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(String xml) throws SchemaValidationException {
        InputSource xmlInput = new InputSource(new BufferedReader(new StringReader(xml)));
        SAXParser sAXParser = this.parser;
        synchronized (sAXParser) {
            try {
                XMLReader xmlReader = this.parser.getXMLReader();
                xmlReader.setContentHandler(new SimpleErrorHandler());
                xmlReader.setErrorHandler(new SimpleErrorHandler());
                xmlReader.parse(xmlInput);
            }
            catch (Exception ex) {
                throw new SchemaValidationException("Invalid Document: " + ex.getMessage(), ex);
            }
        }
    }

    public void validate(File xmlFile) throws SchemaValidationException {
        String xmlText = null;
        try {
            xmlText = Utils.fileToStringBuffer(xmlFile).toString();
        }
        catch (Exception ex) {
            throw new SchemaValidationException("Error reading file: " + ex.getMessage(), ex);
        }
        this.validate(xmlText);
    }

    public static void validate(String xsdFilename, String xmlText) throws SchemaValidationException {
        SchemaValidator validator = new SchemaValidator(xsdFilename);
        validator.validate(xmlText);
    }

    public static void verify(String xsdFilename) throws SchemaValidationException {
        String sl = W3C_NAMESPACE;
        SchemaFactory factory = SchemaFactory.newInstance(W3C_NAMESPACE);
        StreamSource ss = new StreamSource(xsdFilename);
        try {
            factory.newSchema(ss);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new SchemaValidationException(e);
        }
    }

    public static void validate(String xsdFilename, File xmlFile) throws SchemaValidationException {
        String xmlText = null;
        try {
            xmlText = Utils.fileToStringBuffer(xmlFile).toString();
        }
        catch (Exception ex) {
            throw new SchemaValidationException("Error reading file: " + ex.getMessage(), ex);
        }
        SchemaValidator.validate(xsdFilename, xmlText);
    }

    private static void usage() {
        System.err.println("Usage: " + SchemaValidator.class.getName() + " <schemaFile> <xmlFile1> <xmlFile2> .. <xmlFileN>");
        System.err.println("\t<schemaFile> -- The filename of the XSD schema to validate documents against");
        System.err.println("\t<xmlFile1> .. <xmlFileN> -- A list of xml files to validate against the schema");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            SchemaValidator.usage();
            System.exit(1);
        }
        int errorCount = 0;
        SchemaValidator validator = null;
        try {
            validator = new SchemaValidator(args[0]);
        }
        catch (SchemaValidationException ex) {
            System.err.println("Error initializing the schema validator, exiting...");
            ex.printStackTrace();
            System.exit(1);
        }
        for (int i = 1; i < args.length; ++i) {
            try {
                validator.validate(new File(args[i]));
                System.out.println("Valid: " + args[i]);
                continue;
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                ++errorCount;
            }
        }
        System.exit(errorCount);
    }

    private class SimpleErrorHandler
    extends DefaultHandler {
        private SimpleErrorHandler() {
        }

        public void warning(SAXParseException e) {
            System.out.println("Warning Line " + e.getLineNumber() + ": " + e.getMessage() + "\n");
        }

        public void error(SAXParseException e) throws SAXException {
            throw new SAXException("Error Line " + e.getLineNumber() + ": " + e.getMessage(), e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException("Fatal Error Line " + e.getLineNumber() + ": " + e.getMessage(), e);
        }
    }
}

