/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common;

import gov.nih.nci.cagrid.common.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.JFileChooser;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectPrefixUpgrader {
    public static void main(String[] args) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int choice = chooser.showOpenDialog(null);
        if (choice == 0) {
            File baseDir = chooser.getSelectedFile();
            List<File> projectFiles = Utils.recursiveListFiles(baseDir, new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().equals(".project");
                }
            });
            for (int i = 0; i < projectFiles.size(); ++i) {
                File proj = projectFiles.get(i);
                System.out.println("Upgrading " + proj.getAbsolutePath());
                try {
                    FileInputStream in = new FileInputStream(proj);
                    Document doc = XMLUtils.newDocument((InputStream)in);
                    NodeList nodes = doc.getDocumentElement().getChildNodes();
                    for (int j = 0; j < nodes.getLength(); ++j) {
                        Element e;
                        Node n = nodes.item(j);
                        if (n.getNodeType() != 1 || !(e = (Element)n).getNodeName().equals("name")) continue;
                        String projName = e.getTextContent();
                        if (projName.startsWith("caGrid-1.0-")) {
                            projName = "caGrid-" + projName.substring("caGrid-1.0-".length());
                        }
                        e.setTextContent(projName);
                        break;
                    }
                    in.close();
                    FileOutputStream out = new FileOutputStream(proj);
                    XMLUtils.DocumentToStream((Document)doc, (OutputStream)out);
                    out.flush();
                    out.close();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }
}

