/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common;

import gov.nih.nci.cagrid.common.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class JarUtilities {
    public static StringBuffer getFileContents(JarFile jar, String entryName) throws IOException {
        JarEntry entry = jar.getJarEntry(entryName);
        if (entry == null) {
            return null;
        }
        BufferedInputStream entryStream = new BufferedInputStream(jar.getInputStream(entry));
        StringBuffer buffer = Utils.inputStreamToStringBuffer(entryStream);
        return buffer;
    }

    public static byte[] removeJarEntry(JarFile jar, String entryName) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        JarOutputStream jarOut = new JarOutputStream(bytes);
        HashSet<String> copiedEntries = new HashSet<String>();
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry entry = jarEntries.nextElement();
            String name = entry.getName();
            if (name.equals(entryName) || copiedEntries.contains(name)) continue;
            jarOut.putNextEntry(entry);
            InputStream entryStream = jar.getInputStream(entry);
            byte[] entryBytes = JarUtilities.streamToBytes(entryStream);
            entryStream.close();
            jarOut.write(entryBytes);
            jarOut.closeEntry();
            copiedEntries.add(name);
        }
        jarOut.flush();
        jarOut.close();
        return bytes.toByteArray();
    }

    public static void jarDirectory(File dir, File jarFile) throws IOException {
        JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(jarFile));
        List<File> files = Utils.recursiveListFiles(dir, new FileFilter(){

            public boolean accept(File name) {
                return true;
            }
        });
        int baseDirNameLength = dir.getAbsolutePath().length();
        for (File fileToAdd : files) {
            String relativeFileName = fileToAdd.getAbsolutePath().substring(baseDirNameLength + 1);
            JarEntry entry = new JarEntry(relativeFileName);
            jarOut.putNextEntry(entry);
            if (fileToAdd.isDirectory()) continue;
            BufferedInputStream fileInput = new BufferedInputStream(new FileInputStream(fileToAdd));
            JarUtilities.copyStreams(fileInput, jarOut);
            fileInput.close();
        }
        jarOut.flush();
        jarOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertEntry(File jarFile, String entryName, byte[] data) throws IOException {
        File tempJar = File.createTempFile(jarFile.getName(), "tmp");
        tempJar.delete();
        FileOutputStream tempOut = new FileOutputStream(tempJar);
        JarOutputStream jarOut = new JarOutputStream(tempOut);
        try {
            JarFile jarIn = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jarIn.entries();
            while (entries.hasMoreElements()) {
                JarEntry inputEntry = entries.nextElement();
                if (inputEntry.getName().equals(entryName)) continue;
                InputStream entryStream = jarIn.getInputStream(inputEntry);
                jarOut.putNextEntry(inputEntry);
                JarUtilities.copyStreams(entryStream, jarOut);
                jarOut.closeEntry();
            }
            JarEntry insert = new JarEntry(entryName);
            jarOut.putNextEntry(insert);
            JarUtilities.copyStreams(new ByteArrayInputStream(data), jarOut);
            jarOut.closeEntry();
            jarOut.close();
            jarIn.close();
            jarFile.delete();
            Utils.copyFile(tempJar, jarFile);
        }
        finally {
            tempJar.delete();
        }
    }

    private static byte[] streamToBytes(InputStream stream) throws IOException {
        byte[] bytes = new byte[]{};
        byte[] buffer = new byte[8192];
        int len = -1;
        while ((len = stream.read(buffer)) != -1) {
            byte[] temp = new byte[bytes.length + len];
            System.arraycopy(bytes, 0, temp, 0, bytes.length);
            System.arraycopy(buffer, 0, temp, bytes.length, len);
            bytes = temp;
        }
        return bytes;
    }

    private static void copyStreams(InputStream input, OutputStream output) throws IOException {
        byte[] temp = new byte[8192];
        int read = -1;
        while ((read = input.read(temp)) != -1) {
            output.write(temp, 0, read);
        }
    }
}

